--DROP PROCEDURE App.NVCC_usp_GetDivisions

USE [NWIC_PanelMgmt]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [App].[NVCC_usp_GetDivisions]
	@sta3n smallint -- this is the sta3n

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jon Duckart 
--Object/SP Name		: NVCC_usp_GetVAMeds
--SERVER				: DNS.URL        
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-23-2016
--Last Changed          : 08-23-2016
--Last Changed By		: Jon Duckart - Northwest Innovation Center (NWIC)
--Reason For Change		: 
--
--Purpose               : Retrieve a user's Sta6a for VIA calls
--=================================================================================
--Uses: CDWWork.Dim.Division

BEGIN
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON;
	SELECT 
		[DivisionSid]
		,[Sta3n]
		,[DivisionName]  
		,[Sta6a]
	FROM [CDWWork].[Dim].[Division]
	WHERE Sta3n=@sta3n
		AND DivisionName <> '*Unknown at this time*'
END;
GO

EXEC [dbo].[sp_SignAppObject] 'NVCC_usp_GetDivisions'




